package com.qiho.center.api.dto.account;

import java.io.Serializable;
import java.util.Date;

/**
 * 商户充值数据
 * Author: zhanghuifeng
 * Date:   9:51 2017/12/21
 */
public class BaiqiFinanceRechargeDto implements Serializable {

	private static final long serialVersionUID = 7578568388803676763L;

	/**
	 * 充值单号
	 */
	private Long rechargeNo;

	/**
	 * 商户类型，1：商家；2：代理商@see BaiqiCommercialTenantTypeEnum
	 */
	private Integer commercialTenantType;

	/**
	 * 商户id
	 */
	private Long commercialTenantId;

	/**
	 * 现金金额
	 */
	private Integer cashSum;

	/**
	 * 返点金额
	 */
	private Integer rebateSum;

	/**
	 * 提交人
	 */
	private String creator;

	/**
	 * 操作人
	 */
	private String operator;

	/**
	 * 状态 @see BaiqiFinanceRechargeStateEnum
	 */
	private Integer state;

	/**
	 * 备注
	 */
	private String remark;

	/** 创建时间 */
	private Date gmtCreate;

	public Long getRechargeNo() {
		return rechargeNo;
	}

	public void setRechargeNo(Long rechargeNo) {
		this.rechargeNo = rechargeNo;
	}

	public Integer getCommercialTenantType() {
		return commercialTenantType;
	}

	public void setCommercialTenantType(Integer commercialTenantType) {
		this.commercialTenantType = commercialTenantType;
	}

	public Long getCommercialTenantId() {
		return commercialTenantId;
	}

	public void setCommercialTenantId(Long commercialTenantId) {
		this.commercialTenantId = commercialTenantId;
	}

	public Integer getCashSum() {
		return cashSum;
	}

	public void setCashSum(Integer cashSum) {
		this.cashSum = cashSum;
	}

	public Integer getRebateSum() {
		return rebateSum;
	}

	public void setRebateSum(Integer rebateSum) {
		this.rebateSum = rebateSum;
	}

	public String getCreator() {
		return creator;
	}

	public void setCreator(String creator) {
		this.creator = creator;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
}
