package com.qiho.center.api.dto.merchant;

import java.io.Serializable;

/**
 * Created by sunchangji on 2017/12/11.
 */
public class MerchantSimpleDto implements Serializable {

    public MerchantSimpleDto(){}

    public MerchantSimpleDto(Long id, String merchantName){
        this.id = id;
        this.merchantName = merchantName;
    }

    private static final long serialVersionUID = 4540646958316107012L;

    private Long id;

    private String merchantName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MerchantSimpleDto simpleDto = (MerchantSimpleDto) o;

        if (id != null ? !id.equals(simpleDto.id) : simpleDto.id != null) return false;
        return merchantName != null ? merchantName.equals(simpleDto.merchantName) : simpleDto.merchantName == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (merchantName != null ? merchantName.hashCode() : 0);
        return result;
    }
}
