/**
 * Project Name:qiho-center-api File Name:QueryStatisticsDayTypeEnum.java Package Name:com.qiho.center.api.enums
 * Date:2017年6月6日下午12:45:50 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: QueryStatisticsDayTypeEnum <br/>
 * Function:查询数据统计类型枚举. <br/>
 * date: 2017年6月22日 上午10:38:35 <br/>
 *
 * @author chencheng
 * @version
 */
public enum QueryStatisticsDayTypeEnum {
    /** 商品维度查询 */
    ITEAM_QUERY("iteam_query", "维度查询"),

    /** 广告计划维度查询 */
    ADVERT_QUERY("advert_query", "广告计划维度查询"),

    /** 媒体维度查询 */
    APP_QUERY("app_query", "媒体维度查询"),

    /** 出券顺序维度查询 */
    COUPON_NUM_QUERY("Coupon_num_query", "出券顺序维度查询");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private QueryStatisticsDayTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<String, QueryStatisticsDayTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (QueryStatisticsDayTypeEnum it : QueryStatisticsDayTypeEnum.values()) {
            enumMap.put(it.code, it);
        }
    }

    public static QueryStatisticsDayTypeEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
