package com.qiho.center.api.enums.task;

/**
 * @author Wangpf
 * @description 任务状态枚举类
 * @date 2019/12/24 10:28 AM
 */
public enum TaskStatusEnum {

    /**
     * 任务初始化
     */
    INIT("init"),

    /**
     * 任务正在处理中
     */
    HANDLING("handling"),

    /**
     * 任务执行已经完成
     */
    OVER("over")

    ;

    private final String desc;

    TaskStatusEnum(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }
}
