package com.qiho.center.api.constant;

/**
 * 菜单定义
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-08 10:07
 */
public class AccountMenuConstant {

    private AccountMenuConstant() {
    }

    /**
     * 用户登录成功后设置到redis中用户信息的key前缀
     */
    public static final String LOGIN_USER_REDIS_KEY = "BAIQI:FERRARI:USER:";

    /**
     * redis中设置用户权限菜单的key前缀
     */
    public static final String USER_MENU_REDIS_KEY = "BAIQI:FERRARI:USER:MENU:";

    /**
     * redis 用户菜单过期时间1天
     */
    public static final int USER_MENU_REDIS_EXP = 1;

    /**
     * 个人中心
     */
    public static final String PERSON_CENTER = "PersonCenter";

    /**
     * 修改密码
     */
    public static final String MOD_PD = "ModifyPwd";

    /**
     * 操作日志
     */
    public static final String RECORD_LOG = "RecordLog";

    /**
     * 账号菜单编码
     */
    public static final String ACCOUNT = "Account";

    /**
     * 子账号菜单编码
     */
    public static final String SUB_ACCOUNT = "SubAccount";

    /**
     * 财务中心
     */
    public static final String FINANCE = "Finance";

    /**
     * 账户总览
     */
    public static final String FINANCE_OVERVIEW = "FinanceOverview";

    /**
     * 账户明细
     */
    public static final String FINANCE_DETAIL = "FinanceDetail";

    /**
     * 商家管理
     */
    public static final String MERCHANT = "Merchant";

    /**
     * 商家列表
     */
    public static final String MERCHANT_LIST = "MerchantList";

}
