package com.qiho.center.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * Created by liuyao on 2017/5/22.
 * 仅限用于不配送地区黑名单
 */
public enum ExpressCompanyEnum {

    ALL("ALL", "全部类型", "全部类型"),
    YTO("YTO", "圆通COD", "圆通速递"),
    YTO_PAID("YTO_PAID", "圆通速递", "圆通速递");

    private String code;
    private String name;
    private String logisticsName;

    ExpressCompanyEnum(String code, String name, String logisticsName) {
        this.code = code;
        this.name = name;
        this.logisticsName = logisticsName;
    }

    private static Map<String, ExpressCompanyEnum> enumMap     = Maps.newHashMap();
    private static Map<String, ExpressCompanyEnum> nameEnumMap = Maps.newHashMap();
    static {
        for (ExpressCompanyEnum it : ExpressCompanyEnum.values()) {
            enumMap.put(it.code, it);
            nameEnumMap.put(it.name, it);
        }
    }

    public static ExpressCompanyEnum getExpressCompanyByCode(String code) {
        return enumMap.get(code);
    }

    /**
     * getNameByCode:根据编码获取公司名称. <br/>
     *
     * @param code
     * @return DatabaseSchema
     */
    public static ExpressCompanyEnum getByCode(String code) {
        return enumMap.get(code);
    }

    /**
     * getByCode:根据公司名称获取编码. <br/>
     *
     * @param code
     * @return DatabaseSchema
     */
    public static ExpressCompanyEnum getByName(String name) {
        return nameEnumMap.get(name);
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    /**
     * logisticsName.
     *
     * @return the logisticsName
     */
    public String getLogisticsName() {
        return logisticsName;
    }

}
