package com.qiho.center.api.enums.finance;

import org.apache.commons.lang3.StringUtils;

/** 资金操作类型枚举
 * @author chensong
 * @create 2017-12-19 18:53
 **/
public enum FinanceOptTypeEnum {

    OFFLINE_RECHARGE("OFFLINE_RECHARGE", "线下充值", 1),

    REBATE_RECHAGER("REBATE_RECHAGER", "返点充值", 2),

    CASH_RECHARGE("CASH_RECHARGE", "现金充值", 3),

    AGENT_TRANSFER("AGENT_TRANSFER", "代理商划拨", 4),

    AGENT_CALLBACK("AGENT_CALLBACK", "代理商回拨", 5),

    AD_COST("AD_COST", "广告消耗", 6),
    ;

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    /** 数值 */
    private Integer num;

    private FinanceOptTypeEnum(String code, String desc, Integer num){
        this.code = code;
        this.desc = desc;
        this.num = num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getNum() {
        return num;
    }

    public static FinanceOptTypeEnum getByCode(String code){
        for (FinanceOptTypeEnum value : FinanceOptTypeEnum.values() ) {
            if (StringUtils.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }

    public static FinanceOptTypeEnum getByNum(int num){
        for (FinanceOptTypeEnum value : FinanceOptTypeEnum.values()) {
            if (value.getNum().intValue() == num) {
                return value;
            }
        }
        return null;
    }

    public static FinanceOptTypeEnum getByNum(Integer num){
        return getByNum(num.intValue());
    }


}
