package com.qiho.center.api.remoteservice.orderexport;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.orderexport.FieldDto;
import com.qiho.center.api.dto.orderexport.OrderExportTemplateDto;
import com.qiho.center.api.dto.orderexport.TemplateFieldDto;
import com.qiho.center.api.params.orderexport.OrderExportTemplateQueryParams;

import java.util.List;

/**
 * 订单导出模板后台服务
 *
 * @author peanut.huang
 * @date 2017/11/24.
 */
@AdvancedFeignClient
public interface RemoteOrderExportTemplateBackendService {

    /**
     * 分页查询列表
     *
     * @param templateQueryParams
     * @return
     */
    PagenationDto<OrderExportTemplateDto> find4Page(OrderExportTemplateQueryParams templateQueryParams);

    /**
     * 下拉列表，所有模板
     *
     * @return
     */
    List<OrderExportTemplateDto> findTemp4Select();

    /**
     * 保存模板
     *
     *  id == null -> insert
     *  id != null -> update
     *
     * @param id        模板id
     * @param tempName  模板名称
     * @return
     */
    Boolean save(Long id, String tempName);

    /**
     * 根据模板id删除模板
     *
     * <p> a、删除模板本身 </p>
     *
     * <p> b、删除模板与字段道经 </p>
     *
     * @param id  模板id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 查询模板字段
     *
     * @param tempFieldId    模板字段关联主键id
     * @return
     */
    TemplateFieldDto findTempField(Long tempFieldId);

    /**
     * 查询模板字段列表
     *
     * @param tempId   模板id
     * @return
     */
    List<TemplateFieldDto> findTempFields(Long tempId);

    /**
     * 删除模板字段
     *
     * @param tempFieldId    模板字段关联主键id
     * @return
     */
    Boolean deleteTempField(Long tempFieldId);

    /**
     * 保存模板字段
     *
     * @param templateFieldDto
     * @return
     */
    Boolean saveTempField(TemplateFieldDto templateFieldDto);

    /**
     * 字段下拉列表查询
     *
     * @return
     */
    List<FieldDto> findField4Select();
}
