/**
 * Project Name:qiho-center-api File Name:TemplateDto.java Package Name:com.qiho.center.api.dto
 * Date:2017年6月23日上午11:07:46 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import com.qiho.center.api.dto.merchant.MerchantSimpleDto;

import java.util.Date;
import java.util.List;

/**
 * ClassName:TemplateDto <br/>
 * Date: 2017年6月23日 上午11:07:46 <br/>
 *
 * @author zhanglihui
 * @see
 * @since JDK 1.6
 */
public class TemplateDto extends BaseDto {

    /** 主键 */
    private Long    id;

    /** 模板代码 */
    private String  templateCode;

    /** 模板名称 */
    private String  templateName;

    /** 模板内容 */
    private String  templateContext;

    /** 模板是否有效 */
    private Boolean templateEnable;

    /** 创建时间 */
    private Date    gmtCreate;

    /** 修改时间 */
    private Date    gmtModified;

    /** 模板类型 */
    private String  smsType;

    /** 模板id */
    private String noteTemplateId;

    /**
     * 关联的商家Id
     */
    private String relatedMerchantIds;

    /**
     * 相关联的商家信息
     */
    private List<MerchantSimpleDto> merchantList;

    /**
     * 中台短信模版Id
     */
    private Long modelId;

    /**
     * 短信签名Id
     */
    private Long signId;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * templateCode.
     *
     * @return the templateCode
     */
    public String getTemplateCode() {
        return templateCode;
    }

    /**
     * templateCode.
     *
     * @param templateCode the templateCode to set
     */
    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    /**
     * templateName.
     *
     * @return the templateName
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * templateName.
     *
     * @param templateName the templateName to set
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    /**
     * templateContext.
     *
     * @return the templateContext
     */
    public String getTemplateContext() {
        return templateContext;
    }

    /**
     * templateContext.
     *
     * @param templateContext the templateContext to set
     */
    public void setTemplateContext(String templateContext) {
        this.templateContext = templateContext;
    }

    /**
     * templateEnable.
     *
     * @return the templateEnable
     */
    public Boolean getTemplateEnable() {
        return templateEnable;
    }

    /**
     * templateEnable.
     *
     * @param templateEnable the templateEnable to set
     */
    public void setTemplateEnable(Boolean templateEnable) {
        this.templateEnable = templateEnable;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getSmsType() {
        return smsType;
    }

    public void setSmsType(String smsType) {
        this.smsType = smsType;
    }

    public String getNoteTemplateId() {
        return noteTemplateId;
    }

    public void setNoteTemplateId(String noteTemplateId) {
        this.noteTemplateId = noteTemplateId;
    }

    public String getRelatedMerchantIds() {
        return relatedMerchantIds;
    }

    public void setRelatedMerchantIds(String relatedMerchantIds) {
        this.relatedMerchantIds = relatedMerchantIds;
    }

    public List<MerchantSimpleDto> getMerchantList() {
        return merchantList;
    }

    public void setMerchantList(List<MerchantSimpleDto> merchantList) {
        this.merchantList = merchantList;
    }

    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }
}
