package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 快递100物流公司和e店宝物流公司映射枚举
 * Author: zhanghuifeng
 * Date:   11:38 2017/11/21
 */
public enum KuaiDi100LogisticsEnum {
	/** 圆通速递 */
	YTO("yuantong", "YTO", "圆通速递"),

	/** 汇通快运 */
	BEST_EX("huitongkuaidi", "BEST_EX", "汇通快运"),

	STO("shentong", "STO", "申通"),
	EMS("ems", "EMS", "EMS"),
	HHTT("tiantian", "HHTT", "天天快递"),
	SF("shunfeng", "SF", "顺丰快递"),
	YD("yunda", "YD", "韵达"),
	ZTO("zhongtong", "ZTO", "中通"),
	UAPEX("quanyikuaidi", "UAPEX", "全一"),
	JD("jd", "JD", "京东快递"),
	DBL("debangwuliu","DBL","德邦物流");

	private String kuaiDi100Code;

	private String code;

	private String name;

	KuaiDi100LogisticsEnum(String kuaiDi100Code, String code, String name){
		this.kuaiDi100Code = kuaiDi100Code;
		this.code = code;
		this.name = name;
	}

	/**
	 * getByCode
	 *
	 * @param code
	 * @return DatabaseSchema
	 */
	public static KuaiDi100LogisticsEnum getByCode(String code) {
		for (KuaiDi100LogisticsEnum enumVal : KuaiDi100LogisticsEnum.values()) {
			if (StringUtils.equals(code, enumVal.getCode())) {
				return enumVal;
			}
		}
		return null;
	}

	/**
	 * getByKuaiDi100Code
	 *
	 * @param kuaiDi100Code
	 * @return DatabaseSchema
	 */
	public static KuaiDi100LogisticsEnum getByKuaiDi100Code(String kuaiDi100Code) {
		for (KuaiDi100LogisticsEnum enumVal : KuaiDi100LogisticsEnum.values()) {
			if (StringUtils.equals(kuaiDi100Code, enumVal.getKuaiDi100Code())) {
				return enumVal;
			}
		}
		return null;
	}

	public String getKuaiDi100Code() {
		return kuaiDi100Code;
	}

	public String getCode() {
		return code;
	}

	public String getName() {
		return name;
	}
}
