package com.qiho.center.api.remoteservice.account;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.dto.account.BaiqiMainAndAgenAccountDto;
import com.qiho.center.api.params.account.AccountPageParam;
import com.qiho.center.api.params.account.BaiqiAccountParam;

/**
 * 7ho管理后台操作主账户类,别的请勿用
 * <p>
 * Created by sunchangji on 2017/12/7.
 */
@AdvancedFeignClient
public interface RemoteBaiqiAccountBackendService {

    /**
     * 分页获取主账号信息
     *
     * @param pageQueryParams
     * @return
     */
    PagenationDto<BaiqiMainAndAgenAccountDto> findPageMainAccount(AccountPageParam pageQueryParams);

    /**
     * 启用主账号
     *
     * @param id
     * @return
     */
    Boolean enableMainAccount(Long id);

    /**
     * 禁用主账号
     *
     * @param id
     * @return
     */
    Boolean disableMainAccount(Long id) throws BizException;

    /**
     * 新增主账号
     *
     * @param accountDto
     * @return
     */
    Boolean insertMainAccount(BaiqiAccountDto accountDto) throws BizException;

    /**
     * 更新主账号
     *
     * @param accountParam
     * @return
     */
    Boolean updateMainAccount(BaiqiAccountParam accountParam) throws BizException;
}
