package com.qiho.center.api.dto.logistics;

import com.alibaba.fastjson.annotation.JSONField;
import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.ErpErrorCodeReturnEnum;

/**
 * ClassName: QueryLogisticsOrderDto <br/>
 * Function: 订单发货物流信息更新返回DTO. <br/>
 * date: 2017年6月3日 下午2:55:11 <br/>
 *
 * @author chencheng
 * @version
 */
public class ErpLogisticsSyncAckDto extends BaseDto {

    private static final long serialVersionUID = -1999764404234264767L;

    /** 回写的记录id */
    @JSONField(name = "rec_id")
    private String            recId;

    /** 回写状态: 0成功 1失败 */
    private String            status;

    /** 相关描述信息 */
    private String            message;

    /**
     * recId.
     *
     * @return the recId
     */
    public String getRecId() {
        return recId;
    }

    /**
     * recId.
     *
     * @param recId the recId to set
     */
    public void setRecId(String recId) {
        this.recId = recId;
    }

    /**
     * status.
     *
     * @return the status
     */
    public String getStatus() {
        return status;
    }

    /**
     * status.
     *
     * @param status the status to set
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * message.
     *
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * message.
     *
     * @param message the message to set
     */
    public void setMessage(String message) {
        this.message = message;
    }

    public ErpLogisticsSyncAckDto() {
        super();
    }

    public ErpLogisticsSyncAckDto(String recId, String status, String message) {
        super();
        this.recId = recId;
        this.status = status;
        this.message = message;
    }

    public ErpLogisticsSyncAckDto(String recId, ErpErrorCodeReturnEnum errorCodeReturnEnum) {
        super();
        this.recId = recId;
        this.status = errorCodeReturnEnum.getCode();
        this.message = errorCodeReturnEnum.getDesc();
    }

}
