package com.qiho.center.api.enums;

import java.util.stream.Stream;

/**
 * 快递鸟和百奇订单状态映射
 * @author: wangjin
 * @create 2018-06-12 09:19
 **/
public enum ExpressBirdOrderStatusEnum {

    ACCEPT("ACCEPT","1","接单"),

    UNDER_WAY("UNDER_WAY","2","在途"),

    ARRIVE_CITY("SENT_SCAN","201","派件"),
    SENT_SCAN("SENT_SCAN","202", "派件"),
    ARRIVED_DAK("SENT_SCAN", "211", "派件"),

    SUCCESS("SUCCESS","3", "签收成功"),
    NORMAL_SIGN("SUCCESS","301", "签收成功"),
    FINAL_SIGN("SUCCESS", "302", "签收成功"),
    PROXY_SIGN("SUCCESS", "304", "签收成功"),
    DAK_PROXY_SIGN("SUCCESS", "311", "签收成功"),

    TROUBLE("FAILED","4","签收失败"),
    NO_INFO("FAILED","401","签收失败"),
    OVERTIME_SIGN("FAILED","402","签收失败"),
    OVERTIME_UPDATE("FAILED","403","签收失败"),
    SEND_EXCEPTION("FAILED", "405", "签收失败"),
    OVERTIME_NOT_TAKE("FAILED", "412", "签收失败"),

    REJECTED("REJECTED","404","拒签"),

    RETURN_SIGN("RETURN", "406", "退件成功"),

    SEND_BACK("SEND_BACK", "407", "退回中")

    ;

    /** 代码 */
    private String status;

    /** 快递鸟状态码 */
    private String expressBirdStatus;

    /** 描述 */
    private String desc;

    ExpressBirdOrderStatusEnum(String status,String expressBirdStatus,String desc){
        this.status = status;
        this.expressBirdStatus = expressBirdStatus;
        this.desc = desc;
    }

    public static ExpressBirdOrderStatusEnum getByExpressBird(String status){
        return Stream.of(ExpressBirdOrderStatusEnum.values())
                .filter(item -> item.getExpressBirdStatus().equals(status))
                .findFirst()
                .orElse(null);
    }

    public String getStatus(){
        return status;
    }
    public String getExpressBirdStatus(){
        return expressBirdStatus;
    }
    public String getDesc(){
        return desc;
    }
}
