package com.qiho.center.api.enums.blacklist;

/** 来源方式枚举
 * @author chensong
 * @create 2018-04-24 11:04
 **/
public enum SourceTypeEnum {

    MANUAL(1,"MANUAL","手动添加"),

    STRATEGY(2,"STRATEGY","策略添加")

    ;

    private int num;

    private String code;

    private String desc;

    private SourceTypeEnum(int num, String code, String desc){
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static SourceTypeEnum getByNum(int num){
        for (SourceTypeEnum value : SourceTypeEnum.values()) {
            if (value.getNum() == num){
                return value;
            }
        }
        return null;
    }


}
