package com.qiho.center.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.AgentMerchantsDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.agent.BaiqiAgentMerchantDto;
import com.qiho.center.api.params.agent.AgentMerchantPageParams;

import java.util.List;

/**
 * Created by sunchangji on 2017/12/20.
 */
@AdvancedFeignClient
public interface RemoteBaiqiAgentService {

    /**
     * 根据代理商账号查询代理商下所有商家名称
     *
     * @param agentId 代理商id
     * @return
     */
    List<BaiqiAgentMerchantDto> findAgentMerchantsById(Long agentId);

    /**
     * 根据代理商账号查询代理商信息
     *
     * @param agentId 代理商id
     * @return
     */
    BaiqiAgentDto findBaiqiAgentById(Long agentId);

    /**
     * 验证商家是否是改代理商下的商家
     *
     * @param agentId    代理商id
     * @param merchantId 商家id
     * @return true:是,false:否
     */
    Boolean validateMerchantId(Long agentId, Long merchantId);

    /**
     * 根据条件分页查询代理商下的商家列表信息
     * @param pageParams
     * @return
     */
    PagenationDto<AgentMerchantsDto> findPageByAgentId(AgentMerchantPageParams pageParams);

    /**
     * 根据代理商id 获取对外接口信息
     *
     * @param agentId
     *
     * @return
     */
    OpenInterfaceDto findByAgentId(Long agentId);
}
