package com.qiho.center.api.enums;

/**
 * 订单处理方式枚举
 *
 * @author chensong
 * @create 2018-04-24 11:16
 **/
public enum DealTypeEnum {

    FORBID_SUBMIT(1,"FORBID_SUBMIT","提交订单失败"),

    ;

    private int num;

    private String code;

    private String desc;

    private DealTypeEnum(int num, String code, String desc){
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DealTypeEnum getByNum(int num){
        for (DealTypeEnum value : DealTypeEnum.values()) {
            if (value.getNum() == num){
                return value;
            }
        }
        return null;
    }


}
