package com.qiho.center.api.enums;

import java.util.Arrays;

/**
 *  对象的启用状态枚举
 *
 * @author chensong
 * @create 2018-08-17
 */
public enum EnableStatusEnum {


    OFF(0, "OFF", "关闭", false),

    ON(1, "ON", "开启", true);


    /** 数值标识 */
    private int num;

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    /** 状态 */
    private boolean status;

    private EnableStatusEnum(int num, String code, String desc, boolean status) {
        this.num = num;
        this.code = code;
        this.desc = desc;
        this.status = status;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isStatus() {
        return status;
    }

    public static EnableStatusEnum getByNum(int num){
        return Arrays.stream(EnableStatusEnum.values()).filter(e -> e.getNum() == num).findFirst().orElse(null);
    }



}
