/**
 * Project Name:qiho-center-api
 * File Name:DeliveryEnum.java
 * Package Name:com.qiho.center.api.enums
 * Date:2017年5月18日下午2:40:55
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:DeliveryEnum <br/>
 * 发货方式枚举 <br/>
 * Date:     2017年5月18日 下午2:40:55 <br/>
 * @author   zhanglihui
 * @version  
 * @see 	 
 */
public enum DeliveryEnum {
    /** ERP发货 */
    ERP("ERP", "ERP"),
    
    /** 手动发货 */
    MANUAL("MANUAL", "手动发货"),

    /** ERP 手动发货 */
    BOTH("BOTH","ERP 手动发货");
    
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private DeliveryEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return DeliveryEnum
     */
    public static DeliveryEnum getByCode(String code) {
        for (DeliveryEnum enumVal : DeliveryEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     *
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     *
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

