package com.qiho.center.api.enums.order;

import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description 订单取消原因枚举类
 * @date 2019/9/16 10:16 AM
 */
public enum OrderCancelReasonEnum {

    /**
     * 想白p
     */
    TAKE_FOR_FREE("以为免费"),

    /**
     * 已经在其他商家处购买
     */
    HAVE_CONTACTED_MERCHANT("已与其他商家取得联系"),


    /**
     * 别人用我的手机号下单
     */
    NOT_MY_ORDER("非本人下单"),

    /**
     * 女性
     */
    GIRL("女性"),

    /**
     * 学生
     */
    STUDENT("学生"),

    /**
     * 电话未接通
     */
    LINE_NOT_CONNECTED("电话未接通")
    ;

    private final String cancelReason;

    OrderCancelReasonEnum(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public String getCancelReason() {
        return cancelReason;
    }

    /**
     * @return 所有取消订单的原因
     */
    public static List<String> listCancelReason(){
        return Stream.of(OrderCancelReasonEnum.values())
            .map(OrderCancelReasonEnum::getCancelReason).collect(Collectors.toList());
    }

    /**
     * 判断当前原因是否合法
     *
     * @param reason 原因
     * @return
     */
    public static boolean isllegal(String reason){
        if(StringUtils.isBlank(reason)){
            return false;
        }
        return Stream.of(OrderCancelReasonEnum.values())
            .map(OrderCancelReasonEnum::getCancelReason).anyMatch(reason::equals);
    }

}
