package com.qiho.center.api.enums.discount;

import java.util.stream.Stream;

/**
 * 优惠使用条件类型
 * e.g. 订单金额满多少、订单商品数量满多少、在微信分享优惠
 *
 * @author chensong
 * @create 2018-09-04
 */
public enum DiscountUseTermTypeEnum {

    /** 微信分享 */
    WECHAT_SHARE(1, "WECHAT_SHARE", "微信分享"),

    /** 订单金额 */
    ORDER_AMT(2, "ORDER_AMT", "订单金额"),

    /** 商品数量 */
    ITEM_NUM(3, "ORDER_NUM", "商品数量")

    ;

    private Integer value;

    private String code;

    private String desc;

    private DiscountUseTermTypeEnum(Integer value, String code, String desc) {
        this.value = value;
        this.code = code;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据数值获取
     * @param value
     * @return DiscountUseTermTypeEnum
     */
    public DiscountUseTermTypeEnum getByValue(Integer value){
        if (value == null) {
            return null;
        }
        return Stream.of(DiscountUseTermTypeEnum.values())
                .filter(e -> e.getValue().equals(value)).findFirst().orElse(null);
    }


}
