package com.qiho.center.api.enums.logistics;


import java.util.stream.Stream;

/**
 * 物流订阅公司
 * @author: wangjin
 * @create 2018-06-06 19:43
 **/
public enum LogisticsExpressPlatformEnum {

    BIRD("BIRD","快递鸟", 1),
    HUNDRED("HUNDRED","快递100", 2);

    private String code;
    private String name;
    private int num;
    LogisticsExpressPlatformEnum(String code,String name, int num){
        this.code = code;
        this.name = name;
        this.num = num;
    }

    public static LogisticsExpressPlatformEnum getByCode(String code){
        return Stream.of(LogisticsExpressPlatformEnum.values())
                        .filter(e -> e.getCode().equals(code))
                        .findFirst()
                        .orElse(null);
    }

    public String getCode(){
        return code;
    }

    public String getName(){
        return name;
    }

    public int getNum() {
        return num;
    }
}
