package com.qiho.center.api.params.account;

import com.qiho.center.api.params.PageQueryParams;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 账号分页查询参数
 *
 * @author chensong
 * @create 2018-03-30 10:55
 **/
public class AccountPageParam extends PageQueryParams{

    /** 代理商id */
    private Long agentId;

    /** 代理商名称 */
    private String agentName;

    /** 商家id*/
    private Long merchantId;

    /** 商家名称 */
    private String merchantName;

    @ApiModelProperty("联系电话")
    private String accountName;

    @ApiModelProperty("店铺Id")
    private Long shopId;

    @ApiModelProperty("账号类型")
    private Integer accountType;

    @ApiModelProperty("账号状态")
    private Integer accountState;

    /** 代理商id列表 */
    private List<Long> agentIdList;

    /** 商家id列表 */
    private List<Long> merchantIdList;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 代理商所属 AE名称
     */
    private String ownerAeName;

    /**
     * 商家所属 AE ID
     */
    private Long ownerAeId;

    /**
     * 权限代理商id列表这里去上面{@link agentIdList} 进行区分
     *
     */
    private List<Long> permissionAgentIdList;

    /**
     * 权限商家id列表 这里去上面{@link merchantIdList} 进行区分
     */
    private List<Long> permissionMerchantIdList;

    public List<Long> getAgentIdList() {
        return agentIdList;
    }

    public void setAgentIdList(List<Long> agentIdList) {
        this.agentIdList = agentIdList;
    }

    public List<Long> getMerchantIdList() {
        return merchantIdList;
    }

    public void setMerchantIdList(List<Long> merchantIdList) {
        this.merchantIdList = merchantIdList;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOwnerAeName() {
        return ownerAeName;
    }

    public void setOwnerAeName(String ownerAeName) {
        this.ownerAeName = ownerAeName;
    }

    public Long getOwnerAeId() {
        return ownerAeId;
    }

    public void setOwnerAeId(Long ownerAeId) {
        this.ownerAeId = ownerAeId;
    }

    public List<Long> getPermissionAgentIdList() {
        return permissionAgentIdList;
    }

    public void setPermissionAgentIdList(List<Long> permissionAgentIdList) {
        this.permissionAgentIdList = permissionAgentIdList;
    }

    public List<Long> getPermissionMerchantIdList() {
        return permissionMerchantIdList;
    }

    public void setPermissionMerchantIdList(List<Long> permissionMerchantIdList) {
        this.permissionMerchantIdList = permissionMerchantIdList;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getAccountState() {
        return accountState;
    }

    public void setAccountState(Integer accountState) {
        this.accountState = accountState;
    }
}
