package com.qiho.center.api.remoteservice.role;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.role.MerchantRoleDto;
import com.qiho.center.api.params.role.RolePageQueryParam;

import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2020/7/15 10:01 上午
 */
@AdvancedFeignClient
public interface RemoteRoleService {

    /**
     *  创建角色
     *
     * @param merchantRoleDto
     * @return
     */
    boolean createRole(MerchantRoleDto merchantRoleDto);

    /**
     *  批量创建角色
     *
     * @param merchantRoleDtos
     * @return
     */
    boolean batchCreateRole(List<MerchantRoleDto> merchantRoleDtos);

    /**
     * 批量删除角色
     *
     * @param roleIds
     * @return
     */
    boolean batchDeleteRole(List<Long> roleIds);

    /**
     * 根据商家Id 批量查找关联的角色
     *
     * @param merchantId
     * @return
     */
    List<MerchantRoleDto> findRoleByMerchantId(Long merchantId);

    /**
     * 根据商家Id 查找关联的角色
     *
     * @param roleId
     * @return
     */
    List<MerchantRoleDto> findRoleByRoleId(Long roleId);

    /**
     * 根据商家Id 批量查找关联的角色
     *
     * @param roleIds
     * @return
     */
    List<MerchantRoleDto> findRoleByRoleIds(List<Long> roleIds);

    /**
     * 分页查询
     *
     * @param rolePageQueryParam
     * @return
     */
    PagenationDto<MerchantRoleDto>  pageQuery(RolePageQueryParam rolePageQueryParam);
}
