/**
 * Project Name:qiho-center-api File Name:ErpStatusEnum.java Package Name:com.qiho.center.api.enums
 * Date:2017年6月6日上午11:43:32 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:DeErpStatusEnum <br/>
 * 待发货订单枚举. <br/>
 * Date: 2017年6月6日 上午11:43:32 <br/>
 *
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum DeErpStatusEnum {
    /** 待通知 */
    TO_NOTIFY("TO_NOTIFY", "待发货"),

    /** 成功 */
    SUCCESS("SUCCESS", "已发货"),

    /** 失败 */
    FAILED("FAILED", "取消发货");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    DeErpStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return DatabaseSchema
     */
    public static DeErpStatusEnum getByCode(String code) {
        for (DeErpStatusEnum enumVal : DeErpStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
