package com.qiho.center.api.enums.ShotOrder;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/9/7.
 * 订单不同处理方式枚举,其中人工捞单为终态,其余由处理方式进行流转
 */
public enum OrderProcessWayEnum {

    MANUAL_CHECK("MANUAL_CHECK","人工审单"),
    MANUAL_GAIN("MANUAL_GAIN","人工捞单"),
    NOTE_GAIN("NOTE_GAIN","短信捞单");

    OrderProcessWayEnum(String val, String msg) {
        this.val = val;
        this.msg = msg;
    }

    String val;
    String msg;

    /**
     * 通过val值去获取对应的枚举
     * @param val
     */
    public static OrderProcessWayEnum fromVal(String val){
        if(StringUtils.isBlank(val)){
            return null;
        }
        for (OrderProcessWayEnum strategyProcessWayEnum : OrderProcessWayEnum.values()) {
            if (strategyProcessWayEnum.getVal().equals(val)) {
                return strategyProcessWayEnum;
            }
        }
        return null;
    }


    public String getVal() {
        return val;
    }

    public String getMsg() {
        return msg;
    }
}
