package com.qiho.center.api.remoteservice.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.page.*;

import java.util.List;

/**
 * 页面组件服务RPC接口
 * @author chensong
 * @create 2018-08-02
 */
@AdvancedFeignClient
public interface RemotePageComponentService {

    /**
     * 保存组件页面
     * @param pageDto
     * @param pageComponentList
     * @return
     */
    ResultDto<Long> savePageComponent(BaiqiPageDto pageDto, List<PageComponentDto> pageComponentList);

    /**
     * 根据id查找组件页面
     * @param pageId
     * @return
     */
    PageComponentDetailDto findPageComponentById(Long pageId);


    /**
     * 根据id查找组件页面
     * @param pageId
     * @return
     */
    List<PageFormStrategyDto> findPageFormById(Long pageId);

}
