package com.qiho.center.api.dto;

import com.qiho.center.api.constant.YZHSmsConstant;
import com.qiho.center.api.dto.reply.UserReplyDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;

import java.util.Date;
import java.util.List;

/**
 * Created by liuyao on 2017/6/3.
 */
public class OrderSnapshotDto extends BaseDto {

    private static final long serialVersionUID = 5707527291330634267L;

    private Long id;

    private String orderId;

    private Long itemId;

    private String itemName;

    /**
     * 商品简称
     */
    private String itemShortName;

    private String itemNo;

    private String skuNo;

    private String image;

    private String skuName;

    private String consumerName;

    private String mobile;

    private String orderStatus;

    private OrderStatusEnum orderStatusEnum;

    private DeliveryEnum deliveryEnum;

    private String channelId;

    private String countChannelId;

    private String url;

    private String ip;

    private String userAgent;

    private Integer sellingPrice;

    private Integer originalPrice;

    private Integer quantity;

    private String payType;

    private FundStatusEnum fundStatusEnum;

    private Integer orderAmt;

    private String province;

    private String city;

    private String district;

    private String address;

    private String postId;

    private Long skinId;

    /**
     * 物流公司代码
     */
    private String logisticsCode;

    private String logisticsName;

    private String logisticsStatus;

    private String message;

    private Date gmtCreate;

    private Date gmtModified;

    private String tuiaId;

    private Long remainTime;

    private String remark;

    /**
     * 防作弊命中规则，多个规则用,分隔
     */
    private String anticheatRules;

    /**
     * 商品成本
     */
    private Integer itemCost;

    /**
     * 订单处理方式
     */
    private String orderProcessWay;

    /**
     * 人工审单为短信捞单处理时间
     */
    private Date manualCheckTime;

    /**
     * 订单原始金额
     */
    private Integer orderOriginalAmt;

    /**
     * 优惠券id
     */
    private Long couponId;

    /**
     * 商家信息
     */
    private String merchantName;

    private Long merchantId;

    private String erpId;

    /**
     * 配送时间
     */
    private String sendTime;

    /**
     * 来源参数
     */
    private String sid;

    /**
     * 短信状态码 {@link YZHSmsConstant.YZHCODE}
     */
    private String smsRetCode;

    /** 用户回复信息 */
    private List<UserReplyDto> userReplyList;

    /** 推啊用户ID */
    private String tuiaCid;

    /**
     * 用户身份证号
     */
    private String idCard;

    /**
     * 下单的页面ID
     */
    private Long pageId;

    /**
     * 下单的页面表单顺序
     */
    private Integer formNumber;

    /**
     * 订单扩展字段
     */
    private String extJson;

    /**
     * 客服是否已处理
     */
    private Integer isOperate;

    /**
     * 是否是拼团
     */
    private Integer isGroupbuy;

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getTuiaCid() {
        return tuiaCid;
    }

    public void setTuiaCid(String tuiaCid) {
        this.tuiaCid = tuiaCid;
    }

    public List<UserReplyDto> getUserReplyList() {
        return userReplyList;
    }

    public void setUserReplyList(List<UserReplyDto> userReplyList) {
        this.userReplyList = userReplyList;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    /**
     * tuiaId.
     *
     * @return the tuiaId
     */
    public String getTuiaId() {
        return tuiaId;
    }

    /**
     * tuiaId.
     *
     * @param tuiaId the tuiaId to set
     */
    public void setTuiaId(String tuiaId) {
        this.tuiaId = tuiaId;
    }

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * itemId.
     *
     * @return the itemId
     */
    public Long getItemId() {
        return itemId;
    }

    /**
     * itemId.
     *
     * @param itemId the itemId to set
     */
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * itemName.
     *
     * @return the itemName
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * itemName.
     *
     * @param itemName the itemName to set
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * itemShortName.
     *
     * @return the itemShortName
     */
    public String getItemShortName() {
        return itemShortName;
    }

    /**
     * itemShortName.
     *
     * @param itemShortName the itemShortName to set
     */
    public void setItemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
    }

    /**
     * itemNo.
     *
     * @return the itemNo
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * itemNo.
     *
     * @param itemNo the itemNo to set
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * skuNo.
     *
     * @return the skuNo
     */
    public String getSkuNo() {
        return skuNo;
    }

    /**
     * skuNo.
     *
     * @param skuNo the skuNo to set
     */
    public void setSkuNo(String skuNo) {
        this.skuNo = skuNo;
    }

    /**
     * image.
     *
     * @return the image
     */
    public String getImage() {
        return image;
    }

    /**
     * image.
     *
     * @param image the image to set
     */
    public void setImage(String image) {
        this.image = image;
    }

    /**
     * skuName.
     *
     * @return the skuName
     */
    public String getSkuName() {
        return skuName;
    }

    /**
     * skuName.
     *
     * @param skuName the skuName to set
     */
    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    /**
     * consumerName.
     *
     * @return the consumerName
     */
    public String getConsumerName() {
        return consumerName;
    }

    /**
     * consumerName.
     *
     * @param consumerName the consumerName to set
     */
    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    /**
     * mobile.
     *
     * @return the mobile
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * mobile.
     *
     * @param mobile the mobile to set
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    /**
     * orderStatusEnum.
     *
     * @return the orderStatusEnum
     */
    public OrderStatusEnum getOrderStatusEnum() {
        return orderStatusEnum;
    }

    /**
     * orderStatusEnum.
     *
     * @param orderStatusEnum the orderStatusEnum to set
     */
    public void setOrderStatusEnum(OrderStatusEnum orderStatusEnum) {
        this.orderStatusEnum = orderStatusEnum;
    }

    /**
     * deliveryEnum.
     *
     * @return the deliveryEnum
     */
    public DeliveryEnum getDeliveryEnum() {
        return deliveryEnum;
    }

    /**
     * deliveryEnum.
     *
     * @param deliveryEnum the deliveryEnum to set
     */
    public void setDeliveryEnum(DeliveryEnum deliveryEnum) {
        this.deliveryEnum = deliveryEnum;
    }

    /**
     * channelId.
     *
     * @return the channelId
     */
    public String getChannelId() {
        return channelId;
    }

    /**
     * channelId.
     *
     * @param channelId the channelId to set
     */
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    /**
     * countChannelId.
     *
     * @return the countChannelId
     */
    public String getCountChannelId() {
        return countChannelId;
    }

    /**
     * countChannelId.
     *
     * @param countChannelId the countChannelId to set
     */
    public void setCountChannelId(String countChannelId) {
        this.countChannelId = countChannelId;
    }

    /**
     * url.
     *
     * @return the url
     */
    public String getUrl() {
        return url;
    }

    /**
     * url.
     *
     * @param url the url to set
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * ip.
     *
     * @return the ip
     */
    public String getIp() {
        return ip;
    }

    /**
     * ip.
     *
     * @param ip the ip to set
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * userAgent.
     *
     * @return the userAgent
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * userAgent.
     *
     * @param userAgent the userAgent to set
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * sellingPrice.
     *
     * @return the sellingPrice
     */
    public Integer getSellingPrice() {
        return sellingPrice;
    }

    /**
     * sellingPrice.
     *
     * @param sellingPrice the sellingPrice to set
     */
    public void setSellingPrice(Integer sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    /**
     * originalPrice.
     *
     * @return the originalPrice
     */
    public Integer getOriginalPrice() {
        return originalPrice;
    }

    /**
     * originalPrice.
     *
     * @param originalPrice the originalPrice to set
     */
    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    /**
     * quantity.
     *
     * @return the quantity
     */
    public Integer getQuantity() {
        return quantity;
    }

    /**
     * quantity.
     *
     * @param quantity the quantity to set
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    /**
     * payType.
     *
     * @return the payType
     */
    public String getPayType() {
        return payType;
    }

    /**
     * payType.
     *
     * @param payType the payType to set
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

    /**
     * fundStatusEnum.
     *
     * @return the fundStatusEnum
     */
    public FundStatusEnum getFundStatusEnum() {
        return fundStatusEnum;
    }

    /**
     * fundStatusEnum.
     *
     * @param fundStatusEnum the fundStatusEnum to set
     */
    public void setFundStatusEnum(FundStatusEnum fundStatusEnum) {
        this.fundStatusEnum = fundStatusEnum;
    }

    /**
     * orderAmt.
     *
     * @return the orderAmt
     */
    public Integer getOrderAmt() {
        return orderAmt;
    }

    /**
     * orderAmt.
     *
     * @param orderAmt the orderAmt to set
     */
    public void setOrderAmt(Integer orderAmt) {
        this.orderAmt = orderAmt;
    }

    /**
     * province.
     *
     * @return the province
     */
    public String getProvince() {
        return province;
    }

    /**
     * province.
     *
     * @param province the province to set
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * city.
     *
     * @return the city
     */
    public String getCity() {
        return city;
    }

    /**
     * city.
     *
     * @param city the city to set
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * district.
     *
     * @return the district
     */
    public String getDistrict() {
        return district;
    }

    /**
     * district.
     *
     * @param district the district to set
     */
    public void setDistrict(String district) {
        this.district = district;
    }

    /**
     * address.
     *
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * address.
     *
     * @param address the address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * postId.
     *
     * @return the postId
     */
    public String getPostId() {
        return postId;
    }

    /**
     * postId.
     *
     * @param postId the postId to set
     */
    public void setPostId(String postId) {
        this.postId = postId;
    }

    /**
     * logisticsCode.
     *
     * @return the logisticsCode
     */
    public String getLogisticsCode() {
        return logisticsCode;
    }

    /**
     * logisticsCode.
     *
     * @param logisticsCode the logisticsCode to set
     */
    public void setLogisticsCode(String logisticsCode) {
        this.logisticsCode = logisticsCode;
    }

    /**
     * logisticsName.
     *
     * @return the logisticsName
     */
    public String getLogisticsName() {
        return logisticsName;
    }

    /**
     * logisticsName.
     *
     * @param logisticsName the logisticsName to set
     */
    public void setLogisticsName(String logisticsName) {
        this.logisticsName = logisticsName;
    }

    /**
     * logisticsStatus.
     *
     * @return the logisticsStatus
     */
    public String getLogisticsStatus() {
        return logisticsStatus;
    }

    /**
     * logisticsStatus.
     *
     * @param logisticsStatus the logisticsStatus to set
     */
    public void setLogisticsStatus(String logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    /**
     * message.
     *
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * message.
     *
     * @param message the message to set
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * remainTime.
     *
     * @return the remainTime
     */
    public Long getRemainTime() {
        return remainTime;
    }

    /**
     * remainTime.
     *
     * @param remainTime the remainTime to set
     */
    public void setRemainTime(Long remainTime) {
        this.remainTime = remainTime;
    }

    /**
     * remark.
     *
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * anticheatRules.
     *
     * @return the anticheatRules
     */
    public String getAnticheatRules() {
        return anticheatRules;
    }

    /**
     * anticheatRules.
     *
     * @param anticheatRules the anticheatRules to set
     */
    public void setAnticheatRules(String anticheatRules) {
        this.anticheatRules = anticheatRules;
    }

    public Integer getItemCost() {
        return itemCost;
    }

    public void setItemCost(Integer itemCost) {
        this.itemCost = itemCost;
    }

    public String getOrderProcessWay() {
        return orderProcessWay;
    }

    public void setOrderProcessWay(String orderProcessWay) {
        this.orderProcessWay = orderProcessWay;
    }

    public Date getManualCheckTime() {
        return manualCheckTime;
    }

    public void setManualCheckTime(Date manualCheckTime) {
        this.manualCheckTime = manualCheckTime;
    }

    public Integer getOrderOriginalAmt() {
        return orderOriginalAmt;
    }

    public void setOrderOriginalAmt(Integer orderOriginalAmt) {
        this.orderOriginalAmt = orderOriginalAmt;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    public String getSendTime() {
        return sendTime;
    }

    public void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public String getSid() {
        return sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSmsRetCode() {
        return smsRetCode;
    }

    public void setSmsRetCode(String smsRetCode) {
        this.smsRetCode = smsRetCode;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    public String getExtJson() {
        return extJson;
    }

    public void setExtJson(String extJson) {
        this.extJson = extJson;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public Integer getFormNumber() {
        return formNumber;
    }

    public void setFormNumber(Integer formNumber) {
        this.formNumber = formNumber;
    }

    public Integer getIsOperate() {
        return isOperate;
    }

    public void setIsOperate(Integer isOperate) {
        this.isOperate = isOperate;
    }

    public Integer getIsGroupbuy() {
        return isGroupbuy;
    }

    public void setIsGroupbuy(Integer isGroupbuy) {
        this.isGroupbuy = isGroupbuy;
    }
}
