package com.qiho.center.api.dto;

/** 封装调用qiho-center返回结果
 * @author chensong
 * @create 2018-03-23 11:45
 **/
public class ResultDto<T> extends BaseDto{

    private static final long serialVersionUID = 7914045294275629568L;

    private static final String SUCCESS = "success";

    private static final String FAIL = "fail";

    /** 返回结果 */
    private T result;

    /** 业务操作是否成功 */
    private boolean isSuccess = true;

    /** 调用结果信息 */
    private String msg;

    /**
     * 构造成功的返回结果 不带数据
     * @param <T>
     * @return
     */
    public static <T> ResultDto<T> successResult(){
        ResultDto resultDto = new ResultDto();
        resultDto.setMsg(SUCCESS);
        resultDto.setSuccess(true);
        return resultDto;
    }

    /**
     * 构造成功的返回结构 带数据
     * @param result
     * @param <T>
     * @return
     */
    public static <T> ResultDto<T> successResult(T result){
        ResultDto resultDto = new ResultDto();
        resultDto.setResult(result);
        resultDto.setMsg(SUCCESS);
        resultDto.setSuccess(true);
        return resultDto;
    }

    /**
     * 构造失败的返回结果
     * @param msg
     * @param <T>
     * @return
     */
    public static <T> ResultDto<T> failResult(String msg){
        ResultDto resultDto = new ResultDto();
        resultDto.setSuccess(false);
        resultDto.setMsg(msg);
        return resultDto;
    }

    /**
     * 构造默认的失败返回结果
     * @param <T>
     * @return
     */
    public static <T> ResultDto<T> failResult(){
        ResultDto resultDto = new ResultDto();
        resultDto.setSuccess(false);
        resultDto.setMsg(FAIL);
        return resultDto;
    }


    public static <T> ResultDto<T> getInstance(){
        return new ResultDto();
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(boolean success) {
        isSuccess = success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
