package com.qiho.center.api.dto.needsync.cancelledorder;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * 取消订单·记录 DTO.
 * @dateTime 2020-08-05 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class CancelledOrderDto implements Serializable {


    /**
     * 主键·Id
     */
    private Long id;

    /**
     * 订单·手机号
     */
    private String orderMobile;

    /**
     * 订单·创建时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date orderCreateTime;

    /**
     * 商家·名称
     */
    private String merchantName;

    /**
     * 状态
     * -- { 0 : 未导出 , 1 : 已导出 }.
     */
    private Integer status;

    /**
     * 状态说明
     * -- { 0 : 未导出 , 1 : 已导出 }.
     */
    private String statusExplain;

    /**
     * 操作人·名称
     */
    private String operatorName;

    /**
     * 操作·日期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date operatorDate;

    /**
     * 反馈日期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date feedbackDate;

}
