package com.qiho.center.api.enums;

/**
 * ClassName: 七鱼机器人talkType
 * date: 2020.08.06
 *
 * @author YWG.TOP.SONG
 */
public enum QiYuTalkTypeEnum {
    /**
     * 订单已导出
     */
    EXPORT(0, "订单已导出"),

    /**
     * 媒体id不支持自动取消回复
     */
    BLACK_APP(1, "媒体id不支持自动取消回复"),

    /**
     * 机器人不可取消时间回复
     */
    NOT_TIME(2, "机器人不可取消时间回复"),

    /**
     * 订单数量不等于1或不处于待确认状态回复
     */
    ORDER_STATUS_ERROR(3, "订单数量不等于1或不处于待确认状态回复"),

    /**
     * 机器人自动取消订单成功回复
     */
    NO_EXPORT_SUCCESS(4, "机器人自动取消订单成功回复"),

    /**
     * 机器人自动取消订单失败回复
     */
    NO_EXPORT_ERROR(5, "机器人自动取消订单失败回复"),

    /**
     * 自动取消为否的回复
     */
    CUSTOM_NOT_CANCEL(6, "自动取消为否的回复"),

    /**
     * 取消成功的回复
     */
    EXPORT_SUCCESS(7, "取消成功的回复"),

    /**
     * 取消失败的回复
     */
    EXPORT_ERROR(8, "取消失败的回复");

    /**
     * 代码
     */
    private Integer value;

    /**
     * 描述
     */
    private String desc;

    private QiYuTalkTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * @param value
     * @return DatabaseSchema
     */
    public static QiYuTalkTypeEnum getByValue(Integer value) {
        for (QiYuTalkTypeEnum enumVal : QiYuTalkTypeEnum.values()) {
            if (value == enumVal.getValue()) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return value
     */
    public Integer getValue() {
        return value;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

