package com.qiho.center.api.dto.user;

import com.qiho.center.api.enums.user.UserGenderEnum;

import java.io.Serializable;

/**
 * 微信用户dto
 *
 * @author peanut.huang
 * @date 2018/1/26.
 */
public class WechatUserDto implements Serializable {

    private static final long serialVersionUID = 2508125894603751191L;

    /**
     * id
     */
    private Long id;

    /**
     * 微信用户在百奇的用户id
     */
    private Long userId;

    /**
     * 微信体系内的用户唯一标识（小程序，公众号等）
     */
    private String unionId;

    /**
     * 小程序用户唯一标识
     */
    private String miniOpenId;

    /**
     * 用户昵称
     */
    private String nickName;

    /**
     * 用户头像地址
     */
    private String avatarUrl;

    /**
     * 用户的性别 {@link UserGenderEnum#value}
     */
    private Integer gender;

    /**
     * 用户所在城市
     */
    private String city;

    /**
     * 用户所在省份
     */
    private String province;

    /**
     * 用户所在国家
     */
    private String country;

    /**
     * 用户的语言，简体中文为zh_CN
     */
    private String wxLanguage;

    /**
     * 用戶手机号
     */
    private String mobile;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getMiniOpenId() {
        return miniOpenId;
    }

    public void setMiniOpenId(String miniOpenId) {
        this.miniOpenId = miniOpenId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getWxLanguage() {
        return wxLanguage;
    }

    public void setWxLanguage(String wxLanguage) {
        this.wxLanguage = wxLanguage;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
}
