/**
 * Project Name:qiho-center-api File Name:ErpStatusEnum.java Package Name:com.qiho.center.api.enums
 * Date:2017年6月6日上午11:43:32 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:ErpStatusEnum <br/>
 * ERP子订单状态枚举. <br/>
 * Date: 2017年6月6日 上午11:43:32 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum ErpStatusEnum {
    /** 待通知 */
    TO_NOTIFY("TO_NOTIFY", "待通知"),

    /** 成功 */
    SUCCESS("SUCCESS", "返回成功"),

    /** 失败 */
    FAILED("FAILED", "返回失败");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ErpStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return DatabaseSchema
     */
    public static ErpStatusEnum getByCode(String code) {
        for (ErpStatusEnum enumVal : ErpStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
