/**
 * Project Name:qiho-center-api
 * File Name:ErpTypeEnum.java
 * Package Name:com.qiho.center.api.enums
 * Date:2017年6月6日上午11:40:59
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:ErpTypeEnum <br/>
 * ERP类型枚举. <br/>
 * Date:     2017年6月6日 上午11:40:59 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum ErpTypeEnum {
    /** 发货 */
    SEND("SEND", "发货"),
    
    /** 换货 */
    EXCHANGE("EXCHANGE", "换货");
    
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ErpTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return DatabaseSchema
     */
    public static ErpTypeEnum getByCode(String code) {
        for (ErpTypeEnum enumVal : ErpTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     *
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     *
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

