package com.qiho.center.api.enums.finance;

/**
 * CashRebateAmountEnum
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-28 11:27
 */
public enum CashRebateAmountEnum {

    INCOME(0, "存入"),

    EXPENDITURE(1, "支出");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 数值
     */
    private String name;

    CashRebateAmountEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return "CashRebateAmountEnum{" + "code=" + code + ", name='" + name + '\'' + '}';
    }
}
