package com.qiho.center.api.enums.finance;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by xianhongwei on 2017/12/22.
 */
public enum ParterTypeEnum {
    TUIA("推啊",1);

    /** 代码 */
    private String name;

    /** 数值 */
    private Integer code;

    ParterTypeEnum(String name, int code) {
        this.code=code;
        this.name=name;
    }

    public String getName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }

    public static ParterTypeEnum getByName(String name){
        for (ParterTypeEnum value : ParterTypeEnum.values() ) {
            if (StringUtils.equals(value.getName(), name)) {
                return value;
            }
        }
        return null;
    }

    public static ParterTypeEnum getByCode(int code){
        for (ParterTypeEnum value : ParterTypeEnum.values()) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }
}
