package com.qiho.center.api.constant;

import com.qiho.center.api.enums.OverallConfigEnum;

/**
 * 加购配置常量
 *
 * @author peanut.huang
 * @date 2020/7/10
 * @since JDK 1.8
 */
public class PurchaseConstant {

    /**
     * 大字报弹层背景图key
     */
    public static final String BIG_BG_KEY              = "BIG_BG";

    /**
     * 大字报弹层按钮图key
    */
    public static final String BIG_BUTTON_KEY          = "BIG_BUTTON";

    /**
     * 大字报弹层文案key
     */
    public static final String BIG_TEXT_KEY            = "BIG_TEXT";

    /**
     * 大字报弹层绑定媒体key
     */
    public static final String BIG_MEDIA_KEY           = OverallConfigEnum.BIG_MEDIA_KEY.getDesc();

    /**
     * 加粉弹层背景图key
     */
    public static final String JF_BG_KEY               = "JF_BG";

    /**
     * 加粉弹层按钮图key
     */
    public static final String JF_BUTTON_KEY           = "JF_BUTTON";

    /**
     * 加粉弹层文案key
     */
    public static final String JF_TEXT_KEY             = "JF_TEXT";

    /**
     * 加粉弹层绑定媒体key
     */
    public static final String JF_MEDIA_KEY            = OverallConfigEnum.JF_MEDIA_KEY.getDesc();

    /**
     *  自动取消黑名单key
     * */
    public static final String AUTO_CANCEL_BLACK_KEY   = OverallConfigEnum.AUTO_CANCEL_BLACK.getDesc();

    /**
     *  自动取消时间key
     * */
    public static final String AUTO_CANCEL_TIME_KEY   = OverallConfigEnum.AUTO_CANCEL_TIME.getDesc();
}
