package com.qiho.center.api.dto.logistics;

import java.util.Date;
import java.util.Map;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;

/**
 * ClassName: QueryLogisticsOrderDto <br/>
 * Function: 物流订单DTO. <br/>
 * date: 2017年6月3日 下午2:55:11 <br/>
 *
 * @author chencheng
 * @version
 */
public class LogisticsOrderDto extends BaseDto {

    private static final long serialVersionUID = -719948880295433658L;

    /** 订单ID */
    private String            orderId;

    /** ERP订单ID */
    private String            erpId;

    /** 售后订单ID */
    private String            afterSaleOrderId;

    /** 物流订单ID */
    private String            logisticsId;

    /** 物流公司代码 ，{@link ExpressCompanyEnum}*/
    private String            logisticsCode;

    /** 物流公司名称 */
    private String            logisticsName;

    /** 物流单号 */
    private String            postId;

    /** 物流状态，具体由物流公司定义 */
    private String            logisticsStatus;

    /** 物流订单状态，{@link LogisticsOrderStatusEnum} */
    private String            orderStatus;

    /** 创建时间 */
    private Date              gmtCreate;

    /** 更新时间 */
    private Date              gmtModified;

    /** 操作员信息，包含姓名、手机号 */
    private Map<String,String> deliveryMsg;

    /** 订单状态更新时间 */
    private  Date             orderStatusModified;

    /** 备注 */
    private  String           remark;

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * erpId.
     *
     * @return the erpId
     */
    public String getErpId() {
        return erpId;
    }

    /**
     * erpId.
     *
     * @param erpId the erpId to set
     */
    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    /**
     * afterSaleOrderId.
     *
     * @return the afterSaleOrderId
     */
    public String getAfterSaleOrderId() {
        return afterSaleOrderId;
    }

    /**
     * afterSaleOrderId.
     *
     * @param afterSaleOrderId the afterSaleOrderId to set
     */
    public void setAfterSaleOrderId(String afterSaleOrderId) {
        this.afterSaleOrderId = afterSaleOrderId;
    }

    /**
     * logisticsId.
     *
     * @return the logisticsId
     */
    public String getLogisticsId() {
        return logisticsId;
    }

    /**
     * logisticsId.
     *
     * @param logisticsId the logisticsId to set
     */
    public void setLogisticsId(String logisticsId) {
        this.logisticsId = logisticsId;
    }

    /**
     * logisticsCode.
     *
     * @return the logisticsCode
     */
    public String getLogisticsCode() {
        return logisticsCode;
    }

    /**
     * logisticsCode.
     *
     * @param logisticsCode the logisticsCode to set
     */
    public void setLogisticsCode(String logisticsCode) {
        this.logisticsCode = logisticsCode;
    }

    /**
     * logisticsName.
     *
     * @return the logisticsName
     */
    public String getLogisticsName() {
        return logisticsName;
    }

    /**
     * logisticsName.
     *
     * @param logisticsName the logisticsName to set
     */
    public void setLogisticsName(String logisticsName) {
        this.logisticsName = logisticsName;
    }

    /**
     * postId.
     *
     * @return the postId
     */
    public String getPostId() {
        return postId;
    }

    /**
     * postId.
     *
     * @param postId the postId to set
     */
    public void setPostId(String postId) {
        this.postId = postId;
    }

    /**
     * logisticsStatus.
     *
     * @return the logisticsStatus
     */
    public String getLogisticsStatus() {
        return logisticsStatus;
    }

    /**
     * logisticsStatus.
     *
     * @param logisticsStatus the logisticsStatus to set
     */
    public void setLogisticsStatus(String logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    /**
     * orderStatus.
     *
     * @return the orderStatus
     */
    public String getOrderStatus() {
        return orderStatus;
    }

    /**
     * orderStatus.
     *
     * @param orderStatus the orderStatus to set
     */
    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Map<String, String> getDeliveryMsg() {
        return deliveryMsg;
    }

    public void setDeliveryMsg(Map<String, String> deliveryMsg) {
        this.deliveryMsg = deliveryMsg;
    }

    public Date getOrderStatusModified() {
        return orderStatusModified;
    }

    public void setOrderStatusModified(Date orderStatusModified) {
        this.orderStatusModified = orderStatusModified;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
