package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/** 基础的对象数据状态枚举
 *  和数据库的tinyint类型一致
 *  此枚举一般用于数据库的deleted字段
 *
 * @author chensong
 * @create 2018-04-19 15:53
 **/
public enum BaseStatusEmun {

    ENABLED(0, "ENABLED", "可用状态", false),

    DISABLED(1, "DISABLED", "不可用状态", true);


    /** 数字 */
    private Integer num;

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    /** 状态 */
    private boolean status;

    private BaseStatusEmun(Integer num, String code, String desc, boolean status){
        this.num = num;
        this.code = code;
        this.desc = desc;
        this.status = status;
    }

    public Integer getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isStatus() {
        return status;
    }

    public static BaseStatusEmun getByCode(String code) {
        for (BaseStatusEmun enumVal : BaseStatusEmun.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

}
