/**
 * Project Name:qiho-center-api
 * File Name:ErpTypeEnum.java
 * Package Name:com.qiho.center.api.enums
 * Date:2017年6月6日上午11:40:59
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.enums;

/**
 * @Description  operateType
 * @Date 15:10 2020-07-14
 * @Param
 * @return
 **/
public enum CancelOperateTypeEnum {

    //默认
    DEFAULT(0, "DEFAULT"),

    //tuia
    TUI_A(1, "推啊操作取消"),

    //商家
    BUSINESS(2, "商家操作取消"),

    //机器人
    ROBOT(3, "机器人操作取消");


    /** 代码 */
    private Integer code;

    /** 描述 */
    private String desc;

    private CancelOperateTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return DatabaseSchema
     */
    public static CancelOperateTypeEnum getByCode(Integer code) {
        for (CancelOperateTypeEnum enumVal : CancelOperateTypeEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     *
     * @return code
     */
    public Integer getCode() {
        return code;
    }

    /**
     *
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

