package com.qiho.center.api.enums;

import com.google.common.collect.Collections2;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

/**
 * Created by weny.cai on 2017/11/13.
 * ERP 厂商类型
 */
public enum ErpManufacturerType {

    /** 发货 */
    EDB("EDB", "E店宝"),

    /** 换货 */
    WDT("WDT", "旺店通");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    ErpManufacturerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return DatabaseSchema
     */
    public static ErpTypeEnum getByCode(String code) {
        for (ErpTypeEnum enumVal : ErpTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * 根据code获取ErpManufacturerType
     *
     * @param code
     * @return
     */
    public static ErpManufacturerType getErpTypeByCode(final String code) {
        Collection<ErpManufacturerType> cols = Collections2.filter(Arrays.asList(ErpManufacturerType.values()), gs -> Objects.equals(gs.code, code));
        return cols.isEmpty() ? null : cols.iterator().next();
    }

    /**
     *
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     *
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
