/**
 * Project Name:qiho-center-api File Name:OrderStatusEnum.java Package Name:com.qiho.center.api.enums
 * Date:2017年6月2日下午1:52:08 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName:OrderStatusEnum <br/>
 * 订单审核状态枚举. <br/>
 * Date: 2017年6月2日 下午1:52:08 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum OrderApprovalStatusEnum {
    /** 订单待审核 */
    TO_APPROVE("TO_APPROVE", "待审核"),

    /** 审核失败 */
    APPROVE_FAILD("APPROVE_FAILD", "审核失败"),

    /** 订单已发货 */
    APPROVE_SUCCESS("APPROVE_SUCCESS", "审核成功");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private OrderApprovalStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<String,OrderApprovalStatusEnum> enumMap = Maps.newHashMap();
    static {
        for(OrderApprovalStatusEnum it:OrderApprovalStatusEnum.values()){
            enumMap.put(it.code,it);
        }
    }

    public static OrderApprovalStatusEnum getEnumByCode(String code){
        return enumMap.get(code);
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
