package com.qiho.center.api.remoteservice.abtest;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestPlanDto;
import com.qiho.center.api.dto.abtest.TestPlanStrategyDetailDto;
import com.qiho.center.api.params.TestPlanQueryParam;

/**
 * Created by qianjue on 2017/10/10.
 */
@AdvancedFeignClient
public interface RemoteTestPlanService {

	/**
	 * 分页查询测试计划
	 * @param param
	 * @return
	 */
	PagenationDto<TestPlanDto> queryTestPlanListByPage(TestPlanQueryParam param);

	/**
	 * 保存测试计划
	 * @param planDto
	 * @return
	 */
	int  saveTestPlan(TestPlanDto planDto) throws BizException;

	/**
	 * 暂停或恢复测试计划
	 * @param id
	 * @param planStatus
	 * @return
	 */
	boolean  updatePlanStatus(Long id,String planStatus,String updator) throws BizException;

	/**
	 * 逻辑删除测试计划
	 * @param id
	 * @return
	 */
	boolean  deleteTestPlan(Long id,String updator);

	/**
	 * 发布测试计划
	 * @param id
	 * @return
	 */
	boolean  publishTestPlan(Long  id) throws BizException;

	/**
	 * 查询测试信息
	 * @param planId
	 * @return
	 */
	TestPlanDto  queryTestPlanById(Long planId);

	/**
	 * 根据用户id和商品Id返回a/b分组信息
	 * @param itemId
	 * @param acUserId
	 * @return
	 */
	TestPlanStrategyDetailDto queryTestStrategyByItemIdAndUser(Long itemId,String acUserId);

	/**
	 * 根据测试计划code返回基本信息
	 * @param planCode
	 * @return
	 */
	TestPlanStrategyDetailDto queryStrategyDetailByPlanCode(String planCode);
}
