package com.qiho.center.api.remoteservice.merchant;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantUndeliveryDto;
import com.qiho.center.api.params.merchant.MerchantUndeliveryQueryParams;

import java.util.List;

/**
 * 商家不配送后台服务
 *
 * @author peanut.huang
 * @date 2018/1/10.
 */
@AdvancedFeignClient
public interface RemoteMerchantUndeliveryBackendService {

    /**
     * 分页查询商家不配送列表
     *
     * @param queryParams  查询参数
     * @return
     */
    PagenationDto<MerchantUndeliveryDto> find4Page(MerchantUndeliveryQueryParams queryParams);

    /**
     * 根据查询参数查询
     *
     * @param queryParams 查询参数
     * @return
     */
    List<MerchantUndeliveryDto> findByParams(MerchantUndeliveryQueryParams queryParams);

    /**
     * 批量删除
     *
     * @param idList 商家不配送区域记录id集
     * @return
     */
    Boolean deleteByIds(List<Long> idList);

    /**
     * 批量添加商家不配送区域
     *
     * @param undeliveryDtoList
     * @return
     */
    Boolean batchInsert(List<MerchantUndeliveryDto> undeliveryDtoList);
}
