package com.qiho.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.order.WeChatOrderDetailDto;
import com.qiho.center.api.dto.order.WeChatOrderDto;

import java.util.List;

/**
 * @author: wangjin
 * @create 2018-09-05 11:47
 **/
@AdvancedFeignClient
public interface RemoteWeChatOrderService {

    /**
     * 根据用户Id和订单状态查找
     * @param userId
     * @param statusList
     * @return
     */
    List<WeChatOrderDto> queryOrderListByUserIdAndStatus(Long userId, List<String> statusList);

    /**
     * 查找详情
     * @param orderId
     * @return
     */
    WeChatOrderDetailDto findOrderByOrderId(String orderId);

}
