package com.qiho.center.api.enums.finance;

/**
 * 账户充值状态
 * Author: zhanghuifeng
 * Date:   16:23 2017/12/20
 */
public enum BaiqiFinanceRechargeStateEnum {
	EXCEPTION(-2,"异常"),
	CLOSE(-1,"充值关闭"),
	WAIT_AID(0,"待财务助理审批"),
	WAIT_CHARGE(1,"待财务主管审批"),
	SUCCEED(2,"充值成功");

	private int state;

	private String desc;

	BaiqiFinanceRechargeStateEnum(int state, String desc){
		this.state = state;
		this.desc = desc;
	}

	public static BaiqiFinanceRechargeStateEnum getByState(int state){
		for (BaiqiFinanceRechargeStateEnum value : BaiqiFinanceRechargeStateEnum.values()) {
			if (value.getState() == state) {
				return value;
			}
		}
		return null;
	}

	public String getDesc() {
		return desc;
	}

	public int getState() {
		return state;
	}
}
