/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums;

import com.google.common.collect.Collections2;
import com.qiho.center.api.enums.ErpTypeEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum ErpManufacturerType {
    EDB("EDB", "E\u5e97\u5b9d"),
    WDT("WDT", "\u65fa\u5e97\u901a");

    private String code;
    private String desc;

    private ErpManufacturerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ErpTypeEnum getByCode(String code) {
        for (ErpTypeEnum enumVal : ErpTypeEnum.values()) {
            if (!StringUtils.equals((String)code, (String)enumVal.getCode())) continue;
            return enumVal;
        }
        return null;
    }

    public static ErpManufacturerType getErpTypeByCode(String code) {
        Collection cols = Collections2.filter(Arrays.asList(ErpManufacturerType.values()), gs -> Objects.equals(gs.code, code));
        return cols.isEmpty() ? null : (ErpManufacturerType)((Object)cols.iterator().next());
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

