package com.qiho.center.api.dto.finance;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.finance.FinanceStatusEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;

import java.util.Date;

/** 商户 资金账户对象
 * @author chensong
 * @create 2017-12-19 16:45
 **/
public class FinanceDto extends BaseDto {


    private static final long serialVersionUID = -7379294871208006873L;
    /** 主键id */
    private Long id;


    /** 账户类型 */
    private FinanceTypeEnum relationType;

    /** 关联的  商家/代理商 id */
    private Long relationId;

    /** 关联的 商家/代理商  名称 */
    private String name;

    /** 总余额  现金余额+返点余额 */
    private Long totalAmount;

    /** 现金余额 */
    private Long cashAmount;

    /** 账户状态状态   1:处理中、9:异常、10:完成', */
    private FinanceStatusEnum state;

    /** 返点余额 */
    private Long rebateAmount;

    /** 删除标识 */
    private Boolean deleted;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }


    public FinanceTypeEnum getRelationType() {
        return relationType;
    }

    public void setRelationType(FinanceTypeEnum relationType) {
        this.relationType = relationType;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Long getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Long getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(Long cashAmount) {
        this.cashAmount = cashAmount;
    }

    public Long getRebateAmount() {
        return rebateAmount;
    }

    public void setRebateAmount(Long rebateAmount) {
        this.rebateAmount = rebateAmount;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FinanceStatusEnum getState() {
        return state;
    }

    public void setState(FinanceStatusEnum state) {
        this.state = state;
    }
}
