package com.qiho.center.api.dto.needsync.cancelledorder;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * 记录·分页 DTO.
 * @dateTime 2020-08-05 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class PaginationDto<T extends Serializable> implements Serializable {


    /**
     * 总记录·条数
     */
    private Integer total  = 0;

    /**
     * 当前页·数据
     */
    private List<T> list = Collections.emptyList();

}
