/**
 * Project Name:qiho-center-api File Name:QueryStatisticsDayTypeEnum.java Package Name:com.qiho.center.api.enums
 * Date:2017年6月6日下午12:45:50 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: QueryStatisticsDayTypeEnum <br/>
 * Function:黑名单操作类型枚举. <br/>
 * date: 2017年6月22日 上午10:38:35 <br/>
 *
 * @author chencheng
 * @version
 */
public enum QueryBlackListTypeEnum {
    
    /** 快递公司黑名单 */
    EXPRESS_COMPANY("express_company", "快递公司黑名单"),
    
    /** 手动手机号黑名单 */
    MANUAL_PHONE_NUMBER("manual_phone_number", "手机号-手动"),
    
    /** 策略手机号黑名单 */
    STRATEGY_PHONE_NUMBER("strategy_phone_number", "手机号-策略"),

    /** 手动地区黑名单 */
    MANUAL_REGION("manual_region", "地区-手动"),

    /** 策略地区黑名单 */
    STRATEGY_REGION("strategy_region", "地区-策略"),

    /** 快递公司普通件黑名单 */
    EXPRESS_COMPANY_PUTO("epresss_company_puto","圆通普通件"),

    /** 手机下单黑名单 */
    ORDER_PHONE_NUMBER("order_phone_number","手机-下单")
    ;

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private QueryBlackListTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<String, QueryBlackListTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (QueryBlackListTypeEnum it : QueryBlackListTypeEnum.values()) {
            enumMap.put(it.code, it);
        }
    }

    public static QueryBlackListTypeEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
