package com.qiho.center.api.enums.ordertmp;

import com.baiqi.shield.center.api.enums.ordertmp.RiskVerifyTypeEnum;

/** 临时订单检验不通过的枚举
 * @author chensong
 * @create 2018-05-14 16:18
 **/
public enum OrderTmpRiskCheckFailEnum {

    BLACKLIST_FAIL(1, "BLACKLIST_FAIL", "黑名单不通过"),

    FILTER_ORDER_RULE_FAIL(2, "FILTER_ORDER_RULE_FAIL", "过滤规则不通过"),

    BIZ_CHECK_FAIL(3, "BIZ_CHECK_FAIL", "业务校验不通过"),

    CREATE_FORMAL_FAIL(4, "CREATE_FORMAL_FAIL", "创建订单失败");


    private int num;

    private String code;

    private String desc;

    private OrderTmpRiskCheckFailEnum(int num, String code, String desc){
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * shield center 的风控校验命中类型桥接转换
     * @param verifyTypeEnum
     * @return
     */
    public static OrderTmpRiskCheckFailEnum riskVerifyBridge(RiskVerifyTypeEnum verifyTypeEnum){
        if (verifyTypeEnum == null) {
            return null;
        }
        switch (verifyTypeEnum){
            case BLACKLIST:
                return BLACKLIST_FAIL;
            case FILTER_ORDER_RULE:
                return FILTER_ORDER_RULE_FAIL;
            default:
                return null;
        }
    }




}
